/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.connected;

import java.net.Proxy;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class ServerConfiguration {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    private final String url;
    private final String userAgent;
    private final String login;
    private final String password;
    private final Proxy proxy;
    private final String proxyLogin;
    private final String proxyPassword;
    private final int connectTimeoutMs;
    private final int readTimeoutMs;

    private ServerConfiguration(Builder builder) {
        this.url = builder.url;
        this.userAgent = builder.userAgent;
        this.login = builder.login;
        this.password = builder.password;
        this.proxy = builder.proxy;
        this.proxyLogin = builder.proxyLogin;
        this.proxyPassword = builder.proxyPassword;
        this.connectTimeoutMs = builder.connectTimeoutMs;
        this.readTimeoutMs = builder.readTimeoutMs;
    }

    public String getUrl() {
        return this.url;
    }

    @CheckForNull
    public String getUserAgent() {
        return this.userAgent;
    }

    @CheckForNull
    public String getLogin() {
        return this.login;
    }

    @CheckForNull
    public String getPassword() {
        return this.password;
    }

    @CheckForNull
    public Proxy getProxy() {
        return this.proxy;
    }

    @CheckForNull
    public String getProxyLogin() {
        return this.proxyLogin;
    }

    @CheckForNull
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private String userAgent;
        private String login;
        private String password;
        private Proxy proxy;
        private String proxyLogin;
        private String proxyPassword;
        private int connectTimeoutMs = 30000;
        private int readTimeoutMs = 60000;

        private Builder() {
        }

        public Builder userAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder credentials(@Nullable String login, @Nullable String password) {
            this.login = login;
            this.password = password;
            return this;
        }

        public Builder token(@Nullable String token) {
            this.login = token;
            this.password = null;
            return this;
        }

        public Builder connectTimeoutMilliseconds(int i) {
            this.connectTimeoutMs = i;
            return this;
        }

        public Builder readTimeoutMilliseconds(int i) {
            this.readTimeoutMs = i;
            return this;
        }

        public Builder proxy(@Nullable Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyCredentials(@Nullable String proxyLogin, @Nullable String proxyPassword) {
            this.proxyLogin = proxyLogin;
            this.proxyPassword = proxyPassword;
            return this;
        }

        public ServerConfiguration build() {
            if (this.url == null) {
                throw new UnsupportedOperationException("Server URL is mandatory");
            }
            if (this.userAgent == null) {
                throw new UnsupportedOperationException("User agent is mandatory");
            }
            return new ServerConfiguration(this);
        }
    }
}

